function cllr_v_cpd(data,yourPoint,folder_to_store,fileName)

%plots cllr values vs cumulative probability density
%% input
% data : array of randomized cllr values (33 in this case)
% yourPoint : cllr value that is reported before randomization
% folder_to_store : folder to store graphs
% fileName : This represents the title of the plot and the file name to be
% used for storing the plot in the folder
%% output
% draws the cllr vs cumulative probability density plot and saves it to
% folder_to_store with the prescribed fileName

data=[data;yourPoint];
stepx=length(data);
x=sort(data);
pdf = hist(data,x);
pdf_normalize = (pdf'./stepx);
cum_pdf=cumsum(pdf_normalize);

figure;
fname=cat(2,fileName,'.fig');
full_file=fullfile(folder_to_store,fname);

plot(x,cum_pdf,'-b.', 'LineWidth', 1, 'MarkerSize',8);
hold on;
d=find_logical(x==yourPoint);
plot(yourPoint,cum_pdf(d),'ro','MarkerSize',10);
hold on;
plot([0 yourPoint],[cum_pdf(d) cum_pdf(d)],'g--','LineWidth',0.6);
hold on;
plot([yourPoint yourPoint],[0 cum_pdf(d)],'g--','LineWidth',0.6);
xlabel('C_l_l_r');
ylabel('Cumultive Probability Density');
xlim([0 1]);
grid on;
xticks([0:0.1:1]);
title(fileName);
axis square
savefig(full_file);

end

